<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function role()
    {
        return $this->hasOne('App\Models\UserRole');
    }

    public function comments()
    {
        return $this->hasMany('App\Models\Comment', 'user_id');
    }

    public function communications()
    {
        return $this->hasMany('App\Models\Communication', 'user_id');
    }

    public function documents()
    {
        return $this->hasMany('App\Models\Document', 'user_id');
    }

}